-- dubaiOne global stuff

--[[ theme functions ]]

themeInfo = {
	Version = 1.5,
	Date = "May 10, 2009"
};

-- returns false if not in the range of supported builds
local function VersionCheck()
	-- VersionTime only exists in SVN. However, since we can't call it in CVS
	-- without it complaining, this check is void.
	--if VersionTime() ~= nil then return false; end;
	
	-- ItemTransformFunction is SVN only. Of course, if users have popups on,
	-- they'll see this, so we can't test THAT either.
	--if THEME:GetMetric('MusicWheel','ItemTransformFunction') then return false; end;
	local r = SortOrder:Reverse();
	if r['SortOrder_Roulette'] ~= 18 then return false; end;
	
	-- fallthrough; we should get here if using CVS.
	return true;
end;

function InitialScreen()
	return VersionCheck() and "ScreenTitleMenu" or "ScreenVersionMismatch";
end;

--[[ SelectMusic Info ]]
-- SetSSMusicInfo(option)
-- Sets the thing to display on ScreenSelectMusic. Writes to a file.
function SetSSMusicInfo(option)
	-- write file
	local f = RageFileUtil.CreateRageFile();
	local fname = "ssmusic.cfg";
	
	if f:Open("Themes/dubaiOne/Other/"..fname, 2) then
		f:Write( option );
		f:Close();
	else Trace("[dubaiOne:SetSSMusicInfo] Could not write " .. text .. " to " .. fname);
	end;
	
	f:destroy();
	-- write env
	setenv("SSMusicInfo",option);
end

-- GetSSMusicInfo()
-- Returns the value in Themes/dubaiOne/Other/ssmusic.cfg
function GetSSMusicInfo()
	local f = RageFileUtil.CreateRageFile();
	local option;
	
	if f:Open("Themes/dubaiOne/Other/ssmusic.cfg", 1) then
		option = f:Read();
		f:Close();
		setenv("SSMusicInfo",option);
	else
		Trace("[dubaiOne:GetSSMusicInfo] Could not read config");
		f:destroy();
		setenv("SSMusicInfo","DifficultyList");
		return "DifficultyList";
	end;
	f:destroy();
	return option;
end;

--[[ SelectMusic Options ]]
-- SetSSMusicOptions(option)
-- Sets the OptionIcon display on ScreenSelectMusic. Writes to a file.
function SetSSMusicOption(option)
	-- write file
	local f = RageFileUtil.CreateRageFile();
	local fname = "ssmusic_option.cfg";
	
	if f:Open("Themes/dubaiOne/Other/"..fname, 2) then
		f:Write( option );
		f:Close();
	else Trace("[dubaiOne:SetSSMusicOption] Could not write " .. text .. " to " .. fname);
	end;
	
	f:destroy();
	-- write env
	setenv("SSMusicOption",option);
end

-- GetSSMusicOption()
-- Returns the value in Themes/dubaiOne/Other/ssmusic_option.cfg
function GetSSMusicOption()
	local f = RageFileUtil.CreateRageFile();
	local option;
	
	if f:Open("Themes/dubaiOne/Other/ssmusic_option.cfg", 1) then
		option = f:Read();
		f:Close();
		setenv("SSMusicOption",option);
	else
		Trace("[dubaiOne:GetSSMusicOption] Could not read config");
		f:destroy();
		setenv("SSMusicOption","Normal");
		return "Normal";
	end;
	f:destroy();
	return option;
end;

--[[ SongTitle Options ]]
-- SetSongTitleOption(option)
-- Sets the display of song/course title on Gameplay. Writes to a file.
function SetSongTitleOption(option)
	-- write file
	local f = RageFileUtil.CreateRageFile();
	local fname = "gameplay_title.cfg";
	
	if f:Open("Themes/dubaiOne/Other/"..fname, 2) then
		f:Write( tostring(option) );
		f:Close();
	else Trace("[dubaiOne:SetSongTitleOption] Could not write " .. text .. " to " .. fname);
	end;
	
	f:destroy();
	-- write env
	setenv("GameplayTitle",option);
end;

-- GetSongTitleOption()
-- Returns the value in Themes/dubaiOne/Other/gameplay_title.cfg
function GetSongTitleOption()
	local f = RageFileUtil.CreateRageFile();
	local option;
	
	if f:Open("Themes/dubaiOne/Other/gameplay_title.cfg", 1) then
		option = f:Read();
		f:Close();
		setenv("GameplayTitle",option);
	else
		Trace("[dubaiOne:GetSongTitleOption] Could not read config");
		f:destroy();
		setenv("GameplayTitle",true);
		return true;
	end;
	f:destroy();
	return option;
end;

--[[ PlayerOptions Options ]]
-- SetDisplayModsOption(option)
-- Sets the display of player mods on Gameplay. Writes to a file.
function SetDisplayModsOption(option)
	-- write file
	local f = RageFileUtil.CreateRageFile();
	local fname = "gameplay_options.cfg";
	
	if f:Open("Themes/dubaiOne/Other/"..fname, 2) then
		f:Write( tostring(option) );
		f:Close();
	else Trace("[dubaiOne:SetSongTitleOption] Could not write " .. text .. " to " .. fname);
	end;
	
	f:destroy();
	-- write env
	setenv("GameplayTitle",option);
end;

-- GetDisplayModsOption()
-- Returns the value in Themes/dubaiOne/Other/gameplay_options.cfg
function GetDisplayModsOption()
	local f = RageFileUtil.CreateRageFile();
	local option;
	
	if f:Open("Themes/dubaiOne/Other/gameplay_options.cfg", 1) then
		option = f:Read();
		f:Close();
		setenv("GameplayOptions",option);
	else
		Trace("[dubaiOne:GetDisplayModsOption] Could not read config");
		f:destroy();
		setenv("GameplayOptions",true);
		return true;
	end;
	f:destroy();
	return option;
end;

--[[ Toasty Options ]]
-- SetToasty(option)
-- Sets Toasty. Writes to a file.
function SetToasty(option)
	-- write file
	local f = RageFileUtil.CreateRageFile();
	local fname = "toasty.cfg";
	
	if f:Open("Themes/dubaiOne/Other/"..fname, 2) then
		f:Write( option );
		f:Close();
	else Trace("[dubaiOne:SetToasty] Could not write " .. text .. " to " .. fname);
	end;
	
	f:destroy();
	-- write env
	setenv("Toasty",option);
end;

-- GetToasty()
-- Returns the value in Themes/dubaiOne/Other/toasty.cfg
function GetToasty()
	local f = RageFileUtil.CreateRageFile();
	local option;
	
	if f:Open("Themes/dubaiOne/Other/toasty.cfg", 1) then
		option = f:Read();
		f:Close();
		setenv("Toasty",option);
	else
		Trace("[dubaiOne:GetToasty] Could not read config");
		f:destroy();
		setenv("Toasty",true);
		return true;
	end;
	f:destroy();
	return option;
end;

-- AprilFools()
-- Returns true if April 1st. Month is zero-indexed by default.
function AprilFools()
	if DayOfMonth() == 1 and MonthOfYear()+1 == 4 then return true;
	else return false;
	end;
end;

--[[ debug options ]]
-- toggleHumor(bHumor)
-- Toggles the AJ-style irreverent humor on/off.
-- Only meant for devs and can only be set in the debug menu.
function toggleHumor(bHumor)
	setenv("Humor",bHumor);
end;

-- toggleGameplayTitleDisplay(bShow)
-- Toggles display of Song/Course title in Gameplay.
function toggleGameplayTitleDisplay(bShow)
	setenv("GameplayTitle",bShow);
end;

-- togglePlayerOptionsDisplay(bShow)
-- Toggles display of player options in Gameplay.
function togglePlayerOptionsDisplay(bShow)
	setenv("GameplayOptions",bShow);
end;

--[[ Options Menu Rows ]]
function OptionRowHumor()
	local t = {
		-- Name is used to retrieve the header and explanation text.
		Name = "AJ-style Humor";
		LayoutType = "ShowAllInRow";
		SelectType = "SelectOne";
		OneChoiceForAllPlayers = true;
		ExportOnChange = false;
		Choices = { 'Off', 'On' };
		LoadSelections = function(self, list, pn)
			list[1] = true
		end;
		SaveSelections = function(self, list, pn)
			local val;
			if list[1] then
				val = false;
			else
				val = true;
			end
			toggleHumor(val);
		end;
	};
	setmetatable( t, t );
	return t;
end;

function OptionRowSongTitleDisplay()
	local t = {
		-- Name is used to retrieve the header and explanation text.
		Name = "Song/Course Title Display";
		LayoutType = "ShowAllInRow";
		SelectType = "SelectOne";
		OneChoiceForAllPlayers = true;
		ExportOnChange = false;
		Choices = { 'On','Off' };
		LoadSelections = function(self, list, pn)
			list[1] = true
		end;
		SaveSelections = function(self, list, pn)
			local val;
			if list[2] then
				val = false;
			else
				val = true;
			end
			toggleGameplayTitleDisplay(val);
			SetSongTitleOption(val);
		end;
	};
	setmetatable( t, t );
	return t;
end;

function OptionRowPlayerOptionsDisplay()
	local t = {
		-- Name is used to retrieve the header and explanation text.
		Name = "Player Options Display";
		LayoutType = "ShowAllInRow";
		SelectType = "SelectOne";
		OneChoiceForAllPlayers = true;
		ExportOnChange = false;
		Choices = { 'On','Off' };
		LoadSelections = function(self, list, pn)
			list[1] = true
		end;
		SaveSelections = function(self, list, pn)
			local val;
			if list[2] then
				val = false;
			else
				val = true;
			end
			togglePlayerOptionsDisplay(val);
			SetDisplayModsOption(val);
		end;
	};
	setmetatable( t, t );
	return t;
end;